var _____WB$wombat$assign$function_____=function(name){return (self._wb_wombat && self._wb_wombat.local_init && self._wb_wombat.local_init(name))||self[name];};if(!self.__WB_pmw){self.__WB_pmw=function(obj){this.__WB_source=obj;return this;}}{
let window = _____WB$wombat$assign$function_____("window");
let self = _____WB$wombat$assign$function_____("self");
let document = _____WB$wombat$assign$function_____("document");
let location = _____WB$wombat$assign$function_____("location");
let top = _____WB$wombat$assign$function_____("top");
let parent = _____WB$wombat$assign$function_____("parent");
let frames = _____WB$wombat$assign$function_____("frames");
let opens = _____WB$wombat$assign$function_____("opens");
/**
 *  RecommenderController
 *  Ein Controller, der zusätzliche relevante Inhalte zu einer Sophora-ID in Form einer Linkliste läd
 *
 *  @Node_Type DIV-Container
 *  @Node_Signatur (data-ctrl-)recommender
 *
 *  @Konfiguartion  {object}    wird als Wert des HTML Attributs "data-ctrl-recommender" eingegeben
 *      externalId {string}     Sophora-ID des Dokuments, zu dem passende Inhalte geladen werden sollen
 *      recoUrl {string}        URL des Recommender-Services
 *      cdsUrl {string}         CDS-URL
 *
 */
"use strict";
function RecommenderController() { };

RecommenderController.NODE_TYPE = 'recommender';
RecommenderController.NODE_TYPE_RECOMMENDATIONS = 'recommendations';

//RecommenderController.prototype = objectUtil.extendObject(new BaseController(), {
RecommenderController.prototype = jQuery.extend(new BaseController(), {
    createObject: function () {

        const that = this;

        this.referenceId = this.rootConfig.externalId;
        this.recommendationsConts = this.getCtrlRelatedObjects(RecommenderController.NODE_TYPE_RECOMMENDATIONS,this.rootNode);

        this.store = {
            excludeIds: {}
        };

        this.maxDurationFactor;
        this.mediaRatio;

        this.impressionObserver = new IntersectionObserver((entries, observerRef) => {
    
            // The callback is run when the visibility of one or more of the elements
            // being observed has changed. It's also called on page load.
            entries.forEach(async (entry) => {

                var recoCont = that.recommendationsConts.find((rc) => rc.node[0] === entry.target.closest('[data-ctrl-recommendations]') );
                
                if (entry.isIntersecting) {

                    // Once we've observed this element come into view, we can safely remove
                    // the observer since we won't need to import the WC code again

                    setTimeout(() => {
                        observerRef.unobserve(entry.target);
                        that.track(entry.target, 'impression', recoCont);
                    }, 700);
    
                }
    
            });
        });

        var cookie = this.readCookie('wdrReco');

        if( Object.keys(cookie).length > 0 && cookie['maxDurationFactor'] ){
            this.maxDurationFactor =  cookie['maxDurationFactor'];
        }

        if( Object.keys(cookie).length > 0 && cookie['mediaRatio'] ){
            this.mediaRatio =  cookie['mediaRatio'];
        }
        
        this.fetchData(this.recommendationsConts);

    },
    fetchData: async function (recoConts) {

        for (let recoCont of recoConts) {

            var recoConfig = recoCont.config,
                recoUrl = recoConfig.recoUrl ? recoConfig.recoUrl : 'https://web.archive.org/web/20260201195341/https://recoexporte-dev.wdr.de/wdrRecommendations',
                cdsUrl = recoConfig.cdsUrl ? recoConfig.cdsUrl : 'https://web.archive.org/web/20260201195341/https://exportedev.wdr.de/cds-pro/getDocumentByExternalId',
                maxDurationFactor = typeof recoConfig.maxDurationFactor === 'number' ? recoConfig.maxDurationFactor : null,
                externalId = recoConfig.externalId ? recoConfig.externalId : null,
                feedbackUrl = recoConfig.feedbackUrl ? recoConfig.feedbackUrl : null,
                userSettings = recoConfig.userSettings ? recoConfig.userSettings : false,
                weights = recoConfig.weights ? recoConfig.weights : null,
                number = recoConfig.number ? recoConfig.number : 10,
                showImages = recoConfig.hasOwnProperty('showImages') ? recoConfig.showImages : true;

            if( this.maxDurationFactor ){
                maxDurationFactor = this.maxDurationFactor;
            }

            if( this.mediaRatio ){
                weights = this.mediaRatio.map((v) => {
                    return { type: v.id.replace('#slider-', ''), weight: v.ratio }
                });
            }

            if( externalId ){

                if( !this.store.excludeIds[externalId] ){
                    this.store.excludeIds[externalId] = [];
                }

                const json = await this.fetchRecommender({
                    recoUrl: recoUrl,
                    referenceId: externalId,
                    excludeIds: this.store.excludeIds[externalId],
                    maxDurationFactor: maxDurationFactor,
                    weights: weights
                });

                if( json?.ABtestName && json.ABtestName !== '' && json?.abGroup ){
                    app.jq(recoCont.node).attr('data-ab-test-id', json.ABtestName);
                    app.jq(recoCont.node).attr('data-ab-test-group', json.abGroup);            
                }

                // bereits geladene IDs in Array speichern
                this.store.excludeIds[externalId] = [...new Set(
                    this.store.excludeIds[externalId].concat(json.items.map(item => item.id))
                )];

                // mehr Einträge laden um Ausfallsicherheit zu erhöhen
                const json2 = await this.fetchRecommender({
                    recoUrl: recoUrl,
                    referenceId: externalId,
                    excludeIds: this.store.excludeIds[externalId],
                    maxDurationFactor: maxDurationFactor,
                    weights: weights
                });

                // bereits geladene IDs in Array speichern
                this.store.excludeIds[externalId] = [...new Set(
                    this.store.excludeIds[externalId].concat(json2.items.map(item => item.id))
                )];

                const items = json.items.concat(json2.items);

                var output = '<div class="modCon">' + 
                    '<div class="mod modA modPicList picListContent small">' + 
                    '<div class="boxCon"><div class="box"><div class="teaser">' + 
                    '<div class="linklist"><ul class="list"></ul></div>';

                if( userSettings ){
                    output += ( feedbackUrl ? 
                        '<div class="settings"><button data-ctrl-recommender-modal="{ \'feedbackUrl\': \'' + feedbackUrl + '\', \'maxDurationFactor\': ' + maxDurationFactor + ' }">' :
                        '<div class="settings"><button data-ctrl-recommender-modal>'
                    ) + 
                    '<span>Einstellungen</span>' + 
                    '</button></div>';
                }

                output += '</div></div></div>' + 
                    '</div></div>' + 
                    '</div>';

                app.jq(recoCont.node).append(output);

                app.registerController(RecommenderModalController, app.jq(recoCont.node).find('.settings button'));

                this.fetchCds(cdsUrl, recoCont, items, { showImages: showImages, number: number });

            }

        }
    },
    fetchRecommender: async function(args){

        var body = {
            "referenceId": args.referenceId,
            // bereits abgerufene IDs als Include-IDs übermitteln
            "excludedIds": args.excludeIds,
            "maxDurationFactor": args.maxDurationFactor,
        };

        if( args.weights ){
            body['weights'] = args.weights;
        }

        const response = await fetch(args.recoUrl, {
            method: "POST",
            headers: {
                "x-wdr-edgeauth": "9d5ZYcISth2pKmHBXCtVSx6Cl80=",
                "Content-Type": "application/json",
                "pa-id": ((typeof(pa) !== 'undefined' && typeof(pa.getVisitorId) === 'function')?pa.getVisitorId():'')
            },
            body: JSON.stringify(body)
        });

        return await response.json()

    },
    fetchCds: async function(cdsUrl, recoCont, items, args = {}) {

        var that = this;

        var itemsOutput = [];

        for (const item of items) {

            if( args.number && itemsOutput.length === args.number ){
                break;
            }

            await fetch(cdsUrl + "?externalId=" + item.id + "&onlyTeaserData=false&loadContent=true&app=null&fl=")
                .then((response) => {
                    if (response.ok) {
                        return response.json();
                    }
                    return Promise.reject(response);
                })
                .then(json => {

                    var teaserImg;
                    var teaserImgUrl;
                    var mediaType;
                    var uuid;
                    var teaser = json;

                    if (json.mediaType === 'imageGallery') {
                        teaserImg = Object.values(json.containsMedia).find(media => media.mediaType === 'image');
                        mediaType = 'gallery';
                        teaser.title = teaser.schlagzeile;
                    }
                    else {
                        teaserImg = json.teaser && json.teaser.teaserImage ? json.teaser.teaserImage : json.teaserImage;
                        mediaType = json.mediaType;
                        if (mediaType === 'beitrag') {
                            teaser = json.teaser;
                            teaser.title = teaser.schlagzeile;
                        }
                    }

                    if( teaser.externalId ){
                        uuid = teaser.externalId;
                    }
                    else {
                        uuid = teaser.uuid;
                    }

                    if(teaserImg) { teaserImgUrl = teaserImg.url.replace('%%FORMAT%%', 'TeaserNormal'); }

                    let sophoraID = that.getSophoraID(teaser.shareLink);

                    itemsOutput.push('<li id="rl-' + uuid + '"' +
                      ( sophoraID ? 'data-sophora-id="' + sophoraID + '"' : '' ) +
                      ' data-content-type="' + mediaType + '"><a href="' + teaser.shareLink + '?src_organic_detail=Recommender">' +
                        ((args.showImages && teaserImgUrl)?(
                            '<div class="mediaCon"><div class="media mediaA ' + mediaType + '"><picture>' +
                            '<img src="' + teaserImgUrl + '" alt="' + teaserImg.altText + '" width="192" title="' + teaserImg.title + ' | Bildrechte: ' + teaserImg.mediaOrigin + '" loading="lazy" class="img" height="108"></img>' +
                            '</picture></div></div>'
                        ):'') +
                        '<span>' + teaser.title + '</span> <span>|</span> <strong>mehr</strong>' +
                        '</a></li>');

                })
                .catch(err => {
                    console.log(err);
                })

        }

        app.jq(recoCont.node).find('ul.list').html(itemsOutput.join(''));

        app.jq(recoCont.node).find('ul.list li').each((i,v) => {
            if( v.getAttribute('data-sophora-id') ){
                that.impressionObserver.observe(v);
            }
        });

        app.jq(recoCont.node).find('ul.list').on('click', 'a', (event) => {
            var link = event.target,
                teaser = link.closest('li');
            that.track(teaser, 'click', recoCont);
        });

    },
    track: function(teaser, eventType, recoCont) {

        var maxDurationFactor = this.maxDurationFactor ?? recoCont.config.maxDurationFactor,
            mediaRatio = this.mediaRatio?.reduce((a, v) => ({ ...a, [v.id.replace('#slider-','')]: v.ratio}), {}) ?? { audio: 2, video: 2 },
            isDefaultSettings = !(this.mediaRatio && this.maxDurationFactor),
            abTestGroup = app.jq(recoCont.node).attr('data-ab-test-group'),
            abTestId = app.jq(recoCont.node).attr('data-ab-test-id');

        if( gWDRMetaDataInfoObject?.recommender?.sendRecommenderEvent ){
            var contentTypes = {
                'beitrag': 'Artikel',
                'audio': 'Audio',
                'video': 'Video',
                'gallery': 'Fotostrecke'
            }
            var pObj = {
                's:teaser_name': teaser.getAttribute('data-sophora-id'),
                's:teaser_category': 'Recommender',
                's:teaser_type': 'Recommendation',
                'n:teaser_horizontal_position': 1,
                'n:teaser_vertical_position': Math.round((teaser.getBoundingClientRect().top + window.scrollY + (teaser.offsetHeight/2)) / document.body.scrollHeight * 100),
                's:teaser_content_type': contentTypes[teaser.getAttribute('data-content-type')] ?? teaser.getAttribute('data-content-type'),
                's:onsitead_type': 'Self promotion',
                'n:teaser_recommender_setting_audio': mediaRatio.audio,
                'n:teaser_recommender_setting_video': mediaRatio.video,
                'n:teaser_recommender_setting_time': maxDurationFactor,
                'b:teaser_recommender_setting_default': isDefaultSettings
            }
            if( abTestId && abTestGroup ){
                pObj['s:teaser_test_creation'] = abTestGroup;
                pObj['s:teaser_test_id'] = abTestId;
            }
            if( eventType === 'click' ){
                pObj['s:teaser_click_action'] = 'Klick';
            }
            gWDRMetaDataInfoObject.recommender.sendRecommenderEvent('self_promotion.' + eventType, pObj);
        }

    },
    getSophoraID: (url) => {
        let match = url.match(/\/[a-zA-Z0-9\-]*[0-9]{3}\./);
        if( match && match[0] ){
            return match[0].slice(1,-1);
        }
        else {
            return null;
        }
    }
});

Application.CONTROLLERS.forEach((fn, i) => { if( fn.toString().indexOf('RecommenderController') > 0 ){ Application.CONTROLLERS[i] = RecommenderController } });







	


}

/*
     FILE ARCHIVED ON 19:53:41 Feb 01, 2026 AND RETRIEVED FROM THE
     INTERNET ARCHIVE ON 23:05:06 Feb 02, 2026.
     JAVASCRIPT APPENDED BY WAYBACK MACHINE, COPYRIGHT INTERNET ARCHIVE.

     ALL OTHER CONTENT MAY ALSO BE PROTECTED BY COPYRIGHT (17 U.S.C.
     SECTION 108(a)(3)).
*/
/*
playback timings (ms):
  captures_list: 0.502
  exclusion.robots: 0.018
  exclusion.robots.policy: 0.009
  esindex: 0.011
  cdx.remote: 12.042
  LoadShardBlock: 88.122 (3)
  PetaboxLoader3.datanode: 133.882 (5)
  load_resource: 186.034 (2)
  PetaboxLoader3.resolve: 63.779
*/